/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class Icon
implements Comparator<Icon>,
Comparable<Icon> {
    private static List<Icon> icons = null;
    private String tagName;
    private String imagePath;
    private boolean underlayMinimized;
    private ICON_TYPE type;
    private static Icon noneIcon = new Icon(null, ICON_TYPE.NONE);

    public Icon() {
    }

    private Icon(String image, ICON_TYPE type) {
        this.imagePath = image;
        this.type = type;
    }

    private Icon(String image, boolean underlayMinimized, ICON_TYPE type) {
        this.imagePath = image;
        this.underlayMinimized = underlayMinimized;
        this.type = type;
    }

    public Icon(String tagName, String image, boolean underlayMinimized, ICON_TYPE type) {
        this.imagePath = image;
        this.underlayMinimized = underlayMinimized;
        this.type = type;
        this.tagName = tagName;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public boolean isUnderlayMinimized() {
        return this.underlayMinimized;
    }

    public ICON_TYPE getIconType() {
        return this.type;
    }

    public String toString() {
        return this.getEnumName();
    }

    public String getEnumName() {
        if (this.imagePath == null) {
            return "NONE";
        }
        if (this.tagName != null) {
            return this.tagName;
        }
        String imageSplit = File.separator;
        if (imageSplit.equals("\\")) {
            imageSplit = String.valueOf(File.separator) + File.separator;
        }
        String name = this.imagePath;
        String[] split = name.split(imageSplit);
        name = split[split.length - 1];
        name = name.substring(0, name.lastIndexOf("."));
        name = name.toUpperCase().replace(" ", "_").replace("-", "_");
        return name;
    }

    public static void loadIcons() {
        Icon i;
        File f;
        int n;
        File[] fileArray;
        File[] files;
        System.out.println("Loading Icons...");
        icons = new ArrayList<Icon>();
        System.out.println("Loading Teams...");
        File file = new File("legendary" + File.separator + "definitions" + File.separator + "teams.txt");
        if (file.exists()) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(file));
                while ((line = br.readLine()) != null) {
                    if (line == null || line.startsWith("#") || line.isEmpty()) continue;
                    try {
                        String[] split = line.split(",");
                        boolean underlay = false;
                        if (split[2].equals("true")) {
                            underlay = true;
                        }
                        Icon i2 = new Icon(split[0], "legendary" + File.separator + "Teams" + File.separator + split[1], underlay, ICON_TYPE.TEAM);
                        icons.add(i2);
                        System.out.println("Loaded: " + i2.getEnumName());
                    }
                    catch (Exception e) {
                        System.err.println("Failed to load: " + line);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Error loading Team Icons");
                e.printStackTrace();
            }
        }
        System.out.println("Loading Powers...");
        file = new File("legendary" + File.separator + "Powers" + File.separator);
        if (file.exists()) {
            fileArray = files = file.listFiles();
            n = files.length;
            int n2 = 0;
            while (n2 < n) {
                f = fileArray[n2];
                if (f.getName().toLowerCase().endsWith(".png")) {
                    i = new Icon(f.getAbsolutePath(), ICON_TYPE.POWER);
                    icons.add(i);
                    System.out.println("Loaded: " + i.getEnumName());
                }
                ++n2;
            }
        }
        System.out.println("Loading Attributes...");
        file = new File("legendary" + File.separator + "icons" + File.separator);
        if (file.exists()) {
            fileArray = files = file.listFiles();
            n = files.length;
            int n3 = 0;
            while (n3 < n) {
                f = fileArray[n3];
                if (f.getName().toLowerCase().endsWith(".png")) {
                    i = new Icon(f.getAbsolutePath(), ICON_TYPE.ATTRIBUTE);
                    icons.add(i);
                    System.out.println("Loaded: " + i.getEnumName());
                }
                ++n3;
            }
        }
        icons.add(noneIcon);
        System.out.println("Icons Loaded...");
    }

    public static Icon valueOf(String key) {
        if (icons == null) {
            Icon.loadIcons();
        }
        if (key != null && key.equals("NONE")) {
            return noneIcon;
        }
        for (Icon i : icons) {
            if (!key.toUpperCase().equals(i.getEnumName())) continue;
            return i;
        }
        return null;
    }

    public static List<Icon> values() {
        if (icons == null) {
            Icon.loadIcons();
        }
        return icons;
    }

    public static void saveIconDefinitions() {
        try {
            String str = "";
            for (Icon i : Icon.values()) {
                if (!i.type.equals((Object)ICON_TYPE.TEAM)) continue;
                str = String.valueOf(str) + i.getEnumName() + "," + new File(i.getImagePath()).getName() + "," + i.isUnderlayMinimized() + "\n";
            }
            File file = new File("legendary" + File.separator + "definitions" + File.separator + "teams.txt");
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(str);
            bw.close();
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public ICON_TYPE getType() {
        return this.type;
    }

    public void setType(ICON_TYPE type) {
        this.type = type;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public void setUnderlayMinimized(boolean underlayMinimized) {
        this.underlayMinimized = underlayMinimized;
    }

    @Override
    public int compareTo(Icon i) {
        return this.getEnumName().compareTo(i.getEnumName());
    }

    @Override
    public int compare(Icon i1, Icon i2) {
        return i1.getEnumName().compareTo(i2.getEnumName());
    }

    public static enum ICON_TYPE {
        NONE,
        ATTRIBUTE,
        TEAM,
        POWER;

    }
}

